#include <sys/types.h>

#if 0
#include <sys/mac.h>
#else
struct mac_biba_element {
        u_short mbe_type;
        u_short mbe_grade;
};
struct mac_biba {
        int                     mb_flags;
        struct mac_biba_element mb_single;
        struct mac_biba_element mb_rangelow, mb_rangehigh;
};
#endif

#include <security/mac_biba/mac_biba.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mac.h"
#include "mac_module.h"

const char	*mypolicyname = "biba";

int
mac_module_init(const char *policyname, const char *objectname, int argc,
    char *argv[])
{

	if (strcmp(mypolicyname, policyname) != 0)
		return (MAC_ERROR_NOTTHISMODULE);

	return (MAC_SUCCESS);
}

void
mac_module_free(struct mac_member *member)
{

	free(member->mm_data);
}

int
mac_module_from_text(struct mac_member *member, const char *text)
{
	struct mac_biba *mac_biba;

	mac_biba = (struct mac_biba *) malloc(sizeof(*mac_biba));
	if (mac_biba == NULL)
		return (MAC_ERROR_INSUFFUCIENTRESOURCES);
	memset(mac_biba, 0, sizeof(*mac_biba));

	/* Magic biba parsing here. */
	mac_biba->mb_flags = MAC_BIBA_FLAG_SINGLE;
	mac_biba->mb_single.mbe_type = MAC_BIBA_TYPE_EQUAL;

	member->mm_data = mac_biba;
	member->mm_databuflen = sizeof(*mac_biba);
	member->mm_datalen = sizeof(*mac_biba);

	return (MAC_SUCCESS);
}

int
mac_module_prepare(struct mac_member *member)
{
	struct mac_biba *mac_biba;

	mac_biba = (struct mac_biba *) malloc(sizeof(*mac_biba));
	if (mac_biba == NULL)
		return (MAC_ERROR_INSUFFUCIENTRESOURCES);
	memset(mac_biba, 0, sizeof(*mac_biba));

	member->mm_data = mac_biba;
	member->mm_databuflen = sizeof(*mac_biba);
	member->mm_datalen = sizeof(*mac_biba);

	return (MAC_SUCCESS);
}

int
mac_module_to_text(struct mac_member *member, char **text)
{
	struct mac_biba *mac_biba;
	char *single;

	/* XXX: sanity checks on data blob? */

	mac_biba = (struct mac_biba *)member->mm_data;

	single = NULL;
	if (mac_biba->mb_flags & MAC_BIBA_FLAG_SINGLE) {
		switch (mac_biba->mb_single.mbe_type) {
		case MAC_BIBA_TYPE_EQUAL:
			single = "equal";
			break;
		default:
			single = "unknown";
		}
	}
	if (single != NULL)
		*text = strdup(single);
	else
		*text = strdup("unknown");

	return (MAC_SUCCESS);
}
