/*-
 * Copyright (c) 2004 Networks Associates Technology, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

const NFS3_LABEL_PORT			= 5000;
const NFS3_LABEL_FHSIZE			= 64;
const NFS3_LABEL_MAXSTRINGLEN		= 512;

/*
 * Current subset of error numbers of interest.  We might want to just borrow
 * nfsstat3.
 */
enum nfs3_label_status {
	NFS3_LABEL_OK = 0,
	NFS3_LABEL_PERM = 1,
	NFS3_LABEL_IO = 5,
	NFS3_LABEL_NOMEM = 12,
	NFS3_LABEL_ACCES = 13,
	NFS3_LABEL_OPNOTSUPP = 45,
	NFS3_LABEL_STALE = 70,
	NFS3_LABEL_NOSYS = 78
};

/*
 * Local redefinition of NFSv3 handle.  Can we just borrow nfs_fh3?
 */
struct nfs3_label_fh3 {
	opaque data<NFS3_LABEL_FHSIZE>;
};

typedef string nfs3_label_elements<NFS3_LABEL_MAXSTRINGLEN>;
typedef string nfs3_label<NFS3_LABEL_MAXSTRINGLEN>;

/*
 * Arguments to GETLABEL3.
 */
struct GETLABEL3args {
	struct nfs3_label_fh3	object;
	nfs3_label_elements	elements;
};

struct GETLABEL3resok {
	nfs3_label		label;
};

union GETLABEL3res switch (nfs3_label_status status) {
case NFS3_LABEL_OK:
	struct GETLABEL3resok		resok;
default:
	void;
};

/*
 * Arguments to SETLABEL3.
 */
struct SETLABEL3args {
	struct nfs3_label_fh3	object;
	nfs3_label		subject_label;
	nfs3_label		object_label;
};

struct SETLABEL3resok {
	nfs3_label		object_label;
};

union SETLABEL3res switch (nfs3_label_status status) {
case NFS3_LABEL_OK:
	struct SETLABEL3resok		resok;
default:
	void;
};

program NFS3_LABEL_PROGRAM {
	version NFS_LABEL_V3 {
		void
		NFSPROC3_LABEL_NULL(void)			= 0;

		GETLABEL3res
		NFSPROC3_LABEL_GETLABEL(GETLABEL3args)		= 1;

		SETLABEL3res
		NFSPROC3_LABEL_SETLABEL(SETLABEL3args)		= 2;
	} = 3;
} = 123412;
