set terminal postscript eps color solid
#set terminal png
set output "sys-commits.eps"
set ylabel "Commits"
set xlabel "Time"
set xdata time
set timefmt "%Y/%m"
set format x "%m/%y"
set xrange ["1994/04":"2005/04"]

set key left

set xtics rotate (			\
	"2.0" "1995/01",		\
	"2.0.5" "1995/06",		\
	"2.1.0" "1995/11",		\
	"2.1.5" "1996/07",		\
	"2.1.6" "1996/11",		\
	"2.1.7" "1997/02",		\
	"2.2.0" "1997/03",		\
	"2.2.2" "1997/05",		\
	"2.2.5" "1997/10",		\
	"2.2.6" "1998/03",		\
	"2.2.7" "1997/07",		\
	"3.0" "1998/10",		\
	"2.2.8" "1998/11",		\
	"3.1" "1999/02",		\
	"3.2" "1999/05",		\
	"3.3" "1999/09",		\
	"3.4" "1999/12",		\
	"4.0" "2000/03",		\
	"3.5" "2000/06",		\
	"4.1" "2000/07",		\
	"4.1.1" "2000/09",		\
	"4.2" "2000/11",		\
	"4.3" "2001/04",		\
	"4.4" "2001/09",		\
	"4.5" "2002/01",		\
	"4.6" "2002/06",		\
	"4.6.2" "2002/08",		\
	"4.7" "2002/10",		\
	"5.0" "2003/01",		\
	"4.8" "2003/05",		\
	"5.1" "2003/06",		\
	"4.9" "2003/10",		\
	"5.2" "2004/01",		\
	"5.2.1" "2004/02",		\
	"4.10" "2004/05",		\
	"5.3" "2004/11",		\
	"4.11" "2005/1" )
plot \
"data-any/sys.dat" using 1:2 title "any" with lines lw 3, \
"data-HEAD/sys.dat" using 1:2 title "HEAD" with lines lw 3, \
"data-RELENG_5/sys.dat" using 1:2 title "RELENG_5" with lines lw 3, \
"data-RELENG_4/sys.dat" using 1:2 title "RELENG_4" with lines lw 3, \
"data-RELENG_3/sys.dat" using 1:2 title "RELENG_3" with lines lw 3, \
"data-RELENG_2_2/sys.dat" using 1:2 title "RELENG_2_2" with lines lw 3

